﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Script.Services;
using System.Web.Services;

namespace AZVIC.Ei8htPOS.WebUI.Admin.WebService
{
    /// <summary>
    /// Summary description for AzvicService
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    [System.ComponentModel.ToolboxItem(false)]
    [ScriptService]
    public class AzvicService : System.Web.Services.WebService
    {

        [WebMethod(EnableSession = true)]
        [ScriptMethod]
        public AZVIC.Ei8htPOS.Entities.OrdersDetails AddProduct(Guid productID, int Qty, char AddOrUpdateFlag)
        {
            List<Products> pList = ProductsBL.GetList(Guid.Empty, string.Empty);
            if (pList != null && pList.Count > 0)
            {
                pList = pList.Where(a => a.IsActive).ToList<Products>();
            }
            Products myProduct;
            myProduct = pList.Where(p => p.UniqueID == productID).FirstOrDefault<Products>();
            bool IsProductAlreadyAdded = WebSession.CurrentPOSOrders != null && WebSession.CurrentPOSOrders.OrdersDetailsList.Where(a => a.ProductID == productID).Any() ? true : false;
            if (WebSession.CurrentPOSOrders == null)
            {
                WebSession.CurrentPOSOrders = new Orders();
                WebSession.CurrentPOSOrders.Mode = GlobalConfigurations.Mode.Insert;
            }
            if (IsProductAlreadyAdded)
            {
                OrdersDetails currentItem = WebSession.CurrentPOSOrders.OrdersDetailsList.Where(a => a.ProductID == productID).Single();
                WebSession.AddProductToCart(WebSession.CurrentPOSOrders, myProduct, currentItem.OrderPrice, Qty, AddOrUpdateFlag == 'A' ? false : true);
            }
            else
            {
                WebSession.AddProductToCart(WebSession.CurrentPOSOrders, myProduct, myProduct.UnitPrice, Qty, AddOrUpdateFlag == 'A' ? false : true);
            }
            CalculateCartDetails();
            return WebSession.CurrentPOSOrders.OrdersDetailsList.Where(a => a.ProductID == productID).SingleOrDefault();
        }

        [WebMethod(EnableSession = true)]
        [ScriptMethod]
        public List<OrdersDetails> ReturnAllProducts()
        {
            if (WebSession.CurrentPOSOrders != null && WebSession.CurrentPOSOrders.OrdersDetailsList != null)
                return WebSession.CurrentPOSOrders.OrdersDetailsList;
            else
                return new List<OrdersDetails>();
        }

        [WebMethod(EnableSession = true)]
        [ScriptMethod]
        public Orders ReturnOrderDetails()
        {
            CalculateCartDetails();
            if (WebSession.CurrentPOSOrders != null)
                return WebSession.CurrentPOSOrders;
            else
                return new Orders();
        }


        [WebMethod(EnableSession = true)]
        [ScriptMethod]
        public void DeleteProduct(Guid productID)
        {
            WebSession.RemoveProductFromCart(WebSession.CurrentPOSOrders, productID);
            CalculateCartDetails();
        }

        private void CalculateCartDetails()
        {
            if (WebSession.CurrentPOSOrders != null)
            {
                WebSession.CurrentPOSOrders.SubTotal = (from co in WebSession.CurrentPOSOrders.OrdersDetailsList select co).Sum(r => r.Amount);
                decimal discount = 0;
                decimal happyhourdiscount = 0;
                foreach (OrdersDetails od in WebSession.CurrentPOSOrders.OrdersDetailsList)
                {
                    
                    if (WebSession.IsHappyHour)
                    {
                        Products currentProduct = ProductsBL.GetItem(od.ProductID,string.Empty);
                        happyhourdiscount += currentProduct.HappyHourPrice != 0.00M ? od.Quantity * (currentProduct.UnitPrice - currentProduct.HappyHourPrice) : 0.00M;
                    }
                    if (od.DiscountType != null)
                    {
                        if (od.DiscountType.Trim().ToLower().Equals(Constants.DISCOUNT_DOLLAR))
                        {
                            discount += (od.Quantity * od.DiscountValue);
                        }
                        else if (od.DiscountType.Trim().ToLower().Equals(Constants.DISCOUNT_PERCENTAGE))
                        {
                            discount += (od.Quantity * (od.OrderPrice * od.DiscountValue / 100));
                        }
                    }
                }

                WebSession.CurrentPOSOrders.Discount = discount;
                WebSession.CurrentPOSOrders.HappyHoursDiscount = happyhourdiscount;
                WebSession.CurrentPOSOrders.TotalBeforeGST = (WebSession.CurrentPOSOrders.SubTotal - WebSession.CurrentPOSOrders.Discount - WebSession.CurrentPOSOrders.TotalDiscount -                
                WebSession.CurrentPOSOrders.HappyHoursDiscount);
                if (WebSession.ApplyServiceTax)
                {
                    WebSession.CurrentPOSOrders.ServiceTax = (WebSession.CurrentPOSOrders.TotalBeforeGST * 10 / 100);
                }
                decimal AmountTaxCalc = WebSession.CurrentPOSOrders.TotalBeforeGST + WebSession.CurrentPOSOrders.ServiceTax;
                if (WebSession.CurrentGSTSetting)
                {
                    WebSession.CurrentPOSOrders.GST = Math.Round((AmountTaxCalc * WebSession.GSTPercent / 100), 2);
                }
                else
                {
                    WebSession.CurrentPOSOrders.GST = 0;
                }
                WebSession.CurrentPOSOrders.Total = RoundUp(WebSession.CurrentPOSOrders.TotalBeforeGST + WebSession.CurrentPOSOrders.GST + WebSession.CurrentPOSOrders.ServiceTax);

            }
            else
            {
                WebSession.CurrentPOSOrders.SubTotal = WebSession.CurrentPOSOrders.Discount = WebSession.CurrentPOSOrders.TotalBeforeGST = WebSession.CurrentPOSOrders.ServiceTax = WebSession.CurrentPOSOrders.HappyHoursDiscount =WebSession.CurrentPOSOrders.Total = 0;
            }
        }


        private decimal RoundUp(decimal toRound)
        {
            return Math.Round((Math.Round(toRound * 20, MidpointRounding.AwayFromZero) / 20), 2);
        }

        [WebMethod]
        [ScriptMethod]
        public Products UpdateProduct(Guid ProductId, int NewQty,int SequenceNo)
        {
            Products CurrProduct = null;
            if (ProductId != null && ProductId != Guid.Empty)
            {
                CurrProduct = ProductsBL.GetItem(ProductId, string.Empty);
                if (CurrProduct != null)
                {
                    CurrProduct.ActualStock = NewQty;
                    CurrProduct.SequenceNo = SequenceNo;
                    ProductsBL.Save(CurrProduct);
                }
            }
            return CurrProduct;
        }

        [WebMethod]
        [ScriptMethod]
        public ProductMeasurement UpdateSize(Guid MeasurementID, int SeqNo)
        {
            ProductMeasurement CurrSize = null;
            if (MeasurementID != null && MeasurementID != Guid.Empty)
            {
                CurrSize = ProductMeasurementBL.GetItem(MeasurementID, string.Empty);
                if (CurrSize != null)
                {
                    CurrSize.SequenceNo = SeqNo;
                    ProductMeasurementBL.Save(CurrSize);
                }
            }
            return CurrSize;
        }
    }
}
